#version 330
#extension GL_EXT_gpu_shader4 : enable
//Trammel of ArchimedesMod01.fsh  by  Gijs
//https://www.shadertoy.com/view/3lt3DS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
const float GAMMA = 2.2;
const float EXPOSURE = 0.8;

//start Common  //
const float DETAIL    = 1.;
const int   MAX_STEPS = 128;
const float MAX_MARCH = 20.;

const vec3 cameraPosition = vec3(-3,3,2)*1.7;
const vec3 cameraLook = vec3(0,-.8,0);
const vec3 cameraDirection = normalize(cameraLook-cameraPosition);
const vec3 cameraRight = normalize(cross(cameraDirection,vec3(0,1,0)));
const vec3 cameraUp = -cross(cameraDirection,cameraRight);

const float ZOOM = .33;

const vec3  SKY_COLOR  = vec3(.45,.56,1.);
const vec3  SUN_VECTOR = normalize(vec3(1,1.2,.8));
const vec3  SUN_COLOR  = vec3(1.);
const float SUN_SIZE   = 0.0001;

const float OCCLUSION_SPREAD    = 0.01;
const float OCCLUSION_INTENSITY = .1;
const int   OCCLUSION_SAMPLES   = 3;

const float RADIUS = .35;
const float OFFSET = 1.5;
const float BASEW = (OFFSET*2.+RADIUS)*.8;
const float BASEH = 0.4; //percentage
const float THICK = .02;
const float SPEED = .7;

const int AA = 1;//sqaure root of the samples per pixel for anti-aliasing
//end common //
// start buffer  //
mat2 getRotation(float a){  
    float c = cos(a);
    float s = sin(a);
    return mat2(
         c, s,
        -s, c
    ); 
}

vec3 getSky(vec3 dir){
    vec3 d = dir-SUN_VECTOR;
    return SKY_COLOR + SUN_COLOR*min(SUN_SIZE/dot(d,d),1.);
}

float sdCappedCylinder( vec3 p, float h, float r )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

const vec3 n1 = normalize(vec3(1,0,-1));
const vec3 n2 = vec3(0.38268343236,0,-0.92387953251);
const vec3 n3 = vec3(0.19509032201,0,-0.9807852804);

float distanceSpinny(vec3 p){
    float dis = MAX_MARCH;
    mat2 R1 = getRotation(iTime*SPEED);
    mat2 R2 = getRotation(-iTime*SPEED*2.);
    
    p.xz *= R1; 
    p.x -= OFFSET;  
    p.xz *= R2;
    
    float main = sdCappedCylinder(p-vec3(0,RADIUS*2.+3.,0),THICK,3.);
    dis = min(dis,main);
    
    p.xz = abs(p.xz);
    p -= 2.*min(0.,dot(p, n1)) * n1;
    p -= 2.*min(0.,dot(p, n2)) * n2;
    
    p.x -= OFFSET;
    
    float ball = length(p)-RADIUS;
    dis = min(dis,ball);
    
    float stick = sdCappedCylinder(p-vec3(0,1.5*RADIUS,0),THICK,RADIUS*.5);
    dis = min(dis,stick);
    
    float joint = length(p-vec3(0,RADIUS*2.,0))-THICK;
    dis = min(dis,joint);
    
    p.x += OFFSET*.5;
    p.y -= RADIUS*2.;
    float spoke = sdCappedCylinder(p.yxz,THICK,OFFSET*.5); 
    dis = min(dis,spoke);
    
    return dis;
}

float distanceCylinders(vec3 p){
    float dis = MAX_MARCH;

    p.xz = abs(p.xz);
    p -= 2.*min(0.,dot(p, n1)) * n1;
    p -= 2.*min(0.,dot(p, n2)) * n2;
    p -= 2.*min(0.,dot(p, n3)) * n3;
    
    p.x -= OFFSET;

    p = p.yxz;
    dis = min(dis,sdCappedCylinder(p,RADIUS,OFFSET*2.+RADIUS));
    
    return dis;
}

float distanceBase(vec3 p){
    float base = sdCappedCylinder(p+vec3(0,RADIUS*(1.-BASEH),0), BASEW , RADIUS*BASEH);
    float cyl = distanceCylinders(p);
    return max(base,-cyl);
}

float getDistance(vec3 p){
    float dis = MAX_MARCH;
    
    dis = min(dis,p.y+1.);
    dis = min(dis,distanceSpinny(p));
    dis = min(dis,distanceBase(p));
    
	return dis;   
    
}

vec3 getColor(vec3 p){
    return vec3(.75);
}

vec3 getNormal(vec3 p, float eps){
    eps = max(eps,1e-7);
    vec2 k = vec2(1,-1);
    vec2 d = k*eps;
    return normalize( k.xyy*getDistance( p + d.xyy ) + 
                      k.yyx*getDistance( p + d.yyx ) + 
                      k.yxy*getDistance( p + d.yxy ) + 
                      k.xxx*getDistance( p + d.xxx ) );
}


void raymarch(in vec3 p, in vec3 d, float eps, inout int steps, inout float dis, inout float meps, inout float t){
	for (;steps<MAX_STEPS;steps++){
		dis = getDistance(p + d*t);     
        t += dis;
        meps = abs(t)*eps;

		if(dis<=meps){
            t -= (meps-dis);
            break;
        }
        
        if(t>=MAX_MARCH){
            t = MAX_MARCH;
            break;
        }
	}
}

float softshadow(vec3 p, vec3 d, float k, float eps){
    float res = 1.0;
    float ph  = 1e20;
    float t   = 2.*eps;
    
    for(int i=0;i<MAX_STEPS;i++){
        float h = getDistance(p + d*t);
        
        if( h < eps ) return 0.0;
        
        float y = h*h/(2.0*ph);
        float d = sqrt(h*h-y*y);
        res = min( res, k*d/max(0.0,t-y) );
        ph = h;
        t += h;
        
        if(t>MAX_MARCH) break;
    }
    
    return res;
}

float occlusion(vec3 p, vec3 n, float t){
    float o = 1.0;
    float s = OCCLUSION_SPREAD*t;               
    float k = OCCLUSION_INTENSITY/s;  
    float d = 2.0*s;           
    
    for (int i = 0; i < OCCLUSION_SAMPLES; ++i) {
        o -= (d - getDistance(p + n * d)) * k;
        d += s;
        k *= 0.5;
    }
    
    return clamp(o, 0.0, 1.0);
}


vec3 raymarcher(vec3 p, vec3 d, float eps){ 
    int   steps = 0;
    float dis = 0.;
    float meps = 0.;
    float t = 0.;
    raymarch(p,d,eps,steps,dis,meps,t);
    vec3 hitPos    = p + d*t;

    if(dis<meps){

        vec3 hitColor  = getColor(hitPos);
        vec3 hitNormal = getNormal(hitPos,meps);
        vec3 reflectDir = reflect(d,hitNormal);

        float diffuse   = max(dot(hitNormal,SUN_VECTOR),0.);
        float shadow    = diffuse>0. ? softshadow(hitPos + hitNormal*meps*2.,SUN_VECTOR,.1/SUN_SIZE,meps) : 0.;
        float specular  = diffuse>0. && shadow>0. ? pow(max(dot(reflectDir,SUN_VECTOR),0.),32.) : 0.;
        float occlusion = occlusion(hitPos,hitNormal,t);

        vec3 c = hitColor*SUN_COLOR*diffuse*shadow + hitColor*SKY_COLOR*occlusion + SUN_COLOR*specular*shadow*.3;

        return c;
        
    }else{

        return getSky(d); 

    }   
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec4 buf = texture2D(iChannel0,gl_FragCoord.xy / iResolution.xy);
    
    vec3 col = buf.xyz*EXPOSURE;
    col = pow(col,vec3(1./GAMMA));     
    float minResolution = min(iResolution.x,iResolution.y);
    float eps = ZOOM*DETAIL/minResolution;
    
  //  vec3 col = vec3(0);
    
    for(int i=1; i<=AA; i++)
    for(int j=1; j<=AA; j++){
		vec2 p = gl_FragCoord.xy + vec2(i,j)/float(AA);
        
        vec2 uv = (p*2.-iResolution.xy)/minResolution*ZOOM;
    
        vec3 ori = cameraPosition;
        vec3 dir = normalize(cameraDirection+uv.x*cameraRight+uv.y*cameraUp);

        col += raymarcher(ori,dir,eps);
    }
    
    col /= float(AA*AA);
    
    gl_FragColor = vec4(col,1.0);
}
//end buffer  //